/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod.registration;

import io.github.noeppi_noeppi.libx.impl.ModInternal;
import io.github.noeppi_noeppi.libx.mod.ModX;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import io.github.noeppi_noeppi.libx.mod.registration.RegistrationBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ModXRegistration
extends ModX {
    private final Object registrationLock = new Object();
    private final RegistrationBuilder.RegistrationSettings settings;
    private final List<Runnable> registrationHandlers = new ArrayList<Runnable>();
    private boolean registered = false;
    private final List<RegEntry> registrationEntries = new ArrayList<RegEntry>();

    protected ModXRegistration() {
        this(null);
    }

    protected ModXRegistration(@Nullable CreativeModeTab tab) {
        super(tab);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonRegistration);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistration);
        try {
            Method method = EventBus.class.getDeclaredMethod("addListener", EventPriority.class, Predicate.class, Class.class, Consumer.class);
            method.setAccessible(true);
            method.invoke((Object)FMLJavaModLoadingContext.get().getModEventBus(), EventPriority.NORMAL, obj -> true, RegistryEvent.Register.class, this::onRegistry);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not add generic listener to listen to all registry events for mod " + this.modid + ".", e);
        }
        RegistrationBuilder builder = new RegistrationBuilder();
        this.initRegistration(builder);
        this.settings = builder.build();
        ModInternal.get(this).callGeneratedCode();
    }

    public final void addRegistrationHandler(Runnable handler) {
        this.registrationHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(String id, Object obj) {
        if (!ResourceLocation.m_135841_((String)id)) {
            throw new IllegalArgumentException("ModXRegistration#register called with invalid id argument.");
        }
        ResourceLocation rl = this.resource(id);
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.settings.conditions().stream().allMatch(c -> c.shouldRegister(rl, obj))) {
                Object replaced = this.settings.replacers().stream().map(r -> r.getAdditional(rl, obj)).filter(Objects::nonNull).findFirst().orElse(obj);
                this.registrationEntries.add(new RegEntry(id, replaced));
                if (replaced instanceof Registerable) {
                    Registerable reg = (Registerable)replaced;
                    reg.getAdditionalRegisters(rl).forEach(o -> this.register(id, o));
                    reg.getNamedAdditionalRegisters(rl).forEach((str, o) -> this.register(id + "_" + str, o));
                }
                this.settings.transformers().forEach(t -> {
                    Object additional = t.getAdditional(rl, replaced);
                    if (additional != null) {
                        this.register(id, additional);
                    }
                });
            }
        }
    }

    protected abstract void initRegistration(RegistrationBuilder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRegistration() {
        if (!this.registered) {
            Object object = this.registrationLock;
            synchronized (object) {
                if (!this.registered) {
                    this.registered = true;
                    this.registrationHandlers.forEach(Runnable::run);
                }
            }
        }
    }

    private void commonRegistration(FMLCommonSetupEvent event) {
        this.runRegistration();
        this.registrationEntries.forEach(entry -> entry.run(reg -> reg.registerCommon(this.resource(entry.id()), arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0))));
    }

    private void clientRegistration(FMLClientSetupEvent event) {
        this.runRegistration();
        this.registrationEntries.forEach(entry -> entry.run(reg -> reg.registerClient(this.resource(entry.id()), arg_0 -> ((FMLClientSetupEvent)event).enqueueWork(arg_0))));
    }

    private void onRegistry(RegistryEvent.Register<? extends IForgeRegistryEntry<?>> event) {
        this.runRegistration();
        this.registrationEntries.stream().filter(entry -> entry.value() instanceof IForgeRegistryEntry).filter(entry -> event.getRegistry().getRegistrySuperType().equals(((IForgeRegistryEntry)entry.value()).getRegistryType())).forEach(entry -> {
            ((IForgeRegistryEntry)entry.value()).setRegistryName(this.resource(entry.id()));
            event.getRegistry().register((IForgeRegistryEntry)entry.value());
        });
    }

    private record RegEntry(String id, Object value) {
        public void run(Consumer<Registerable> action) {
            if (this.value instanceof Registerable) {
                action.accept((Registerable)this.value);
            }
        }
    }
}

